/* Questo sketch disegna un uniciclo in ambiente 3D che raggiunge la proiezione sul piano di un 
punto in posizione (xDes,yDes,zDes) (valori modificabili da tastiera come indicato sotto). 
Il punto desiderato viene rappresentato mediante un cubetto bianco.
Vengono scritte a schermo sia le coordinate dell'uniciclo sia quelle del punto desiderato, nonché 
lo stato dell'uniciclo se in STOP o in GO.
Le coordinate sono impostate nel seguente modo: il piano dove si muove l'uniciclo (in grigio)
è il piano z = 0, con z crescente verso l'alto. L'origine sta al centro del piano,
con l'asse x verso destra e l'asse y verso l'interno dell'immagine, a formare una terna
ortonormale destra come quelle utilizzate a lezione e quindi diversa da quella usata
da Processing.
I tasti u/U e d/D permettono di alzare e rispettivamente abbassare la visuale della scena. 
Frecce DESTRA/SINISTRA = si aumenta/diminuisce xDes.
Frecce SU/GIU = si aumenta/diminuisce yDes.
Tasti +/-: si aumenta/diminuisce zDes.
I tasti p/P e m/M permettono di aumentare e rispettivamente diminuire phiDes e quindi di cambiare
l'orientamento dell'obiettivo.
Con il tasto s/S si può fermare istantaneamente l'uniciclo mentre con g/G riparte. 
*/

// Parametro altezza telecamera 
float eyeY = 0;

boolean STOP;

// VARIABILI UNICICLO
//Posizione uniciclo
float xU = 0;
float yU = 0;
float thetaU = 0;
// Velocità desiderate impostate da tastiera
float v1Des = 0;
float v2Des = 0;
// Altri parametri
float lUniciclo = 100; // lunghezza uniciclo
float pUniciclo = 60; // larghezza uniciclo
float hUniciclo = 40; // altezza uniciclo 
float kv1 = 2; // costante legge proporzionale controllo v1
float kv2 = 5;  // costante legge proporzionale controllo v2
int nGiriU = 0; // conta quanti giri su se stesso ha fatto l'uniciclo
float thetaDes; // orientamento desiderato (per raggiungere il target)

float dt = (float) 1/60; // tempo di campionamento (in secondi)

// DIMENSIONI SCARA (da utilizzare quando si introdurrà lo SCARA) 
float sLink = 20; // Sezione link 
float lLink = 150; // Lunghezza link
// Dimensioni link 0:
float d0x = sLink; // lungo x
float d0y = lLink; // lungo y
float d0z = sLink; // lungo z
// dimensioni link 1
float d1x = lLink; // lungo x
float d1y = sLink; // lungo y
float d1z = sLink; // lungo z
// dimensioni link 2
float d2x = lLink; // lungo x
float d2y = sLink; // lungo y
float d2z = sLink; // lungo z
// dimensioni link 3
float d3x = sLink; // lungo x
float d3y = lLink; // lungo y
float d3z = sLink; // lungo z
// dimensioni base pinza
float d4x = sLink; // lungo x
float d4y = 10; // lungo y
float d4z = 50; // lungo z
// dimensioni barre pinza
float d5x = sLink; // lungo x
float d5y = 30; // lungo y
float d5z = 10; // lungo z

float xDes, yDes, zDes; // coordinate punto desiderato
float phiDes = 0; // orientamento desiderato oggetto

////////////// SETUP
void setup() 
{
  size(1000, 800, P3D);
  stroke(255);
  strokeWeight(2);
  xDes = 100;
  yDes = 60;
  zDes = 80;
  eyeY = 75;
}

////////////// DRAW
void draw() 
{
  
  background(0);

  pushMatrix();
  lights();
  camera((width/2.0), height/2 - eyeY, (height/2.0) / tan(PI*60.0 / 360.0), width/2.0, height/2.0, 0, 0, 1, 0);  

  // Verifico se e quale tasto è stato premuto
  controllaTastiera();
  
  // assegno velocità secondo legge proporzionale
  v1Des = kv1*((xDes-xU)*cos(thetaU) + (yDes-yU)*sin(thetaU)); 

  // Calcolo l'angolo verso il target: scelgo il multiplo di 2PI 
  // più vicino all'orientamento corrente del robot
  thetaDes = atan2(yDes-yU,xDes-xU) + nGiriU*2*PI;
  if (abs(thetaDes+2*PI-thetaU) < abs(thetaDes-thetaU))
  {
    thetaDes = thetaDes+2*PI;
    nGiriU += 1;
  }
  else
  {
    if (abs(thetaDes-2*PI-thetaU) < abs(thetaDes-thetaU))
    {
      thetaDes = thetaDes-2*PI;
      nGiriU += -1;
    }
  }

  // assegno velocità angolare secondo legge proporzionale    
  v2Des = kv2*(thetaDes-thetaU);

  
  if (STOP)
  {
    v1Des = 0;
    v2Des = 0;
  }

  // Cinematica uniciclo
  xU = xU + v1Des*cos(thetaU)*dt;
  yU = yU + v1Des*sin(thetaU)*dt;
  thetaU = thetaU + v2Des*dt;

  // Disegno il piano d'appoggio
  fill(150);
  translate(width/2,height/2+d0y/2);
  beginShape();
    vertex(-width/2,0,-500);
    vertex(width/2,0,-500);
    vertex(width/2,0,500);
    vertex(-width/2,0,500);
  endShape(CLOSE);
  // Disegno assi x e y sul piano
  beginShape(); // asse x
    vertex(0,0,1);
    vertex(width/2-20,0,1);
    vertex(width/2-50,0,15);
    vertex(width/2,0,0);
    vertex(width/2-50,0,-15);
    vertex(width/2-20,0,-1);
    vertex(0,0,-1);
  endShape(CLOSE);
  beginShape(); // asse y
    vertex(-1,0,0);  
    vertex(-1,0,-480);
    vertex(-15,0,-450);
    vertex(0,0,-500);
    vertex(15,0,-450);
    vertex(1,0,-480);
    vertex(1,0,0);
  endShape(CLOSE);
  
  pushMatrix();
  
  // Disegno uniciclo in rosso con freccia davanti
  translate(xU,-hUniciclo/2,-yU);
  rotateY(thetaU);
  fill(255,0,0);
  box(lUniciclo,hUniciclo,pUniciclo); // uniciclo
  if (STOP)
  {
    disegnaFreccia(2);
  }
  else
  {
    disegnaFreccia(1);
  }

  popMatrix(); // Ritorna al sistema di riferimento di base (z=0 sul piano d'appoggio)
  
  // Disegna punto desiderato
  translate(xDes,-zDes,-yDes);
  fill(255);
  rotateY(phiDes);
  box(10,10,10);
  
  popMatrix();
  
  // Scrivo sullo schermo le variabili d'interesse
  scriviTesto();
  
} 

////////////// CONTROLLA_TASTIERA
void controllaTastiera()
{
  if (keyPressed)
  {
    if ((key == 'd') || (key == 'D')) // abbasso la telecamera
    {
      eyeY -= 5;
    }
    if ((key == 'u') || (key == 'U')) // alzo la telecamera
    {
      eyeY += 5;
    }
    if ((key == 's') || (key == 'S'))  // fermo l'uniciclo
    {
      STOP = true;
    }
    if ((key == 'g') || (key == 'G'))  // riavvio l'uniciclo
    {
      STOP = false;
    }
    if (keyCode == LEFT) 
    {
      xDes = xDes - 5;
    }
    if (keyCode == RIGHT) 
    {
      xDes = xDes + 5;
    }
    if (keyCode == DOWN)
    {
      yDes = yDes - 5;
    }
    if (keyCode == UP)
    {
      yDes = yDes + 5;
    }
    if (key == '-') 
    {
      zDes = zDes - 2;
    }
    if (key == '+') 
    {
      zDes = zDes + 2;
    }
    if (key == 'm' || key == 'M') 
    {
      phiDes = phiDes - PI/180;
    }
    if (key == 'p' || key == 'P') 
    {
      phiDes = phiDes + PI/180;
    }
  }  
}  

////////////// DISEGNA_FRECCIA
void disegnaFreccia(int tipo)
{
  translate(lUniciclo/2,0,0);
  strokeWeight(5);
  if (tipo == 1)
  {
    fill(0,255,0);
    stroke(0,255,0);
  }
  else
  {
    fill(255,0,0);
    stroke(255,0,0);
  }
  beginShape();
    vertex(0,0,5);
    vertex(20,0,5);
    vertex(20,0,10);
    vertex(30,0,0);
    vertex(20,0,-10);
    vertex(20,0,-5);    
    vertex(0,0,-5);    
  endShape(CLOSE);
  beginShape();
    vertex(0,-5,0);
    vertex(20,-5,0);
    vertex(20,-10,0);
    vertex(30,0,0);
    vertex(20,10,0);
    vertex(20,5,0);    
    vertex(0,5,0);    
  endShape(CLOSE);
  strokeWeight(1);
  stroke(255);
}

////////////// SCRIVI_TESTO
void scriviTesto()
{

  fill(255,0,0);  
  text("xU = ",500,100); 
  text(xU,550,100);
  text("yU = ",650,100); 
  text(yU,700,100);  
  text("thetaU = ",800,100); 
  text(atan2(sin(thetaU),cos(thetaU))*180/PI,900,100);
  fill(255);
  text("xDes = ",400,140); 
  text(xDes,470,140);
  text("yDes = ",600,140); 
  text(yDes,670,140);  
  text("zDes = ",800,140); 
  text(zDes,870,140);
  text("phiDes = ",800,180); 
  text(atan2(sin(phiDes),cos(phiDes))*180/PI,900,180);
  if (STOP)
  {
    textSize(25);
    fill(255,0,0);
    text("STOP",width-500,50);
  }
  else
  {
    textSize(25);
    fill(0,255,0);
    text("GO",width-500,50);
  }
  
}
